#version 330

uniform mat4 worldviewproj;
#if _FRUSTUM_RAY
uniform mat4 frustumCorners;
#endif

in vec4 vertex;
in vec2 uv0;

out vec4 uv;
#if _FRUSTUM_RAY
out vec4 frustumRay;
#endif

void main()
{
    gl_Position = worldviewproj * vertex;
	uv = vec4(uv0, 0, 0);
    //vec2 nPos = sign(vertex.xy); //Makes sure it's exact
    //uv = vec4((vec2(nPos.x, -nPos.y) + 1.0f) * 0.5f, 0, 0);// Convert to image-space
#if _FRUSTUM_RAY
	mat4 corners = transpose(frustumCorners);
	frustumRay = corners[int(uv.x) + int(uv.y)*2];
#endif
}
